/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.Server;
import noppes.npcs.api.entity.data.IMiniMapData;
import noppes.npcs.api.entity.data.IPlayerMiniMap;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.data.MiniMapData;
import noppes.npcs.util.Util;

public class PlayerMiniMapData
implements IPlayerMiniMap {
    public final List<MiniMapData> points = new ArrayList<MiniMapData>();
    public String modName = "non";
    private boolean update;
    public Map<String, Object> addData = new HashMap<String, Object>();

    @Override
    public IMiniMapData addPoint(int dimensionId) {
        if (this.modName.equals("non")) {
            return new MiniMapData();
        }
        MiniMapData mmd = new MiniMapData();
        mmd.dimIDs = new int[]{dimensionId};
        mmd.id = this.points.size();
        if (this.modName.equals("voxelmap")) {
            mmd.icon = "";
        }
        this.points.add(mmd);
        this.update = true;
        return mmd;
    }

    @Override
    public IMiniMapData[] getAllPoints() {
        return this.points.toArray(new IMiniMapData[0]);
    }

    @Override
    public String getModName() {
        return this.modName;
    }

    private NBTTagCompound getNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("ModName", this.modName);
        NBTTagList pList = new NBTTagList();
        for (MiniMapData mmd : this.points) {
            pList.func_74742_a((NBTBase)mmd.save());
        }
        nbt.func_74782_a("Data", (NBTBase)pList);
        return nbt;
    }

    @Override
    public IMiniMapData getPoint(int id) {
        if (id < 0 || id >= this.points.size()) {
            return null;
        }
        MiniMapData mmd = this.points.get(id);
        if (mmd != null && mmd.id == id) {
            return mmd;
        }
        for (MiniMapData mmdc : this.points) {
            if (mmdc.id != id) continue;
            return mmdc;
        }
        return null;
    }

    @Override
    public IMiniMapData getPoint(String name) {
        for (MiniMapData mmd : this.points) {
            if (!mmd.name.equals(name)) continue;
            return mmd;
        }
        return null;
    }

    @Override
    public IMiniMapData[] getPoints(int dimensionId) {
        ArrayList<MiniMapData> list = new ArrayList<MiniMapData>();
        block0: for (MiniMapData mmd : this.points) {
            for (int id : mmd.dimIDs) {
                if (id != dimensionId) continue;
                list.add(mmd);
                continue block0;
            }
        }
        return list.toArray(new IMiniMapData[0]);
    }

    public MiniMapData getQuestTask(int questId, int taskId, String questName, int dimID) {
        questName = Util.instance.deleteColor(questName);
        for (MiniMapData mmd : this.points) {
            if (mmd.isQuestTask(questId, taskId)) {
                return mmd;
            }
            if (!mmd.name.equals(questName)) continue;
            for (int id : mmd.dimIDs) {
                if (id != dimID) continue;
                return mmd;
            }
        }
        return null;
    }

    @Override
    public String[] getSpecificKeys() {
        return this.addData.keySet().toArray(new String[0]);
    }

    @Override
    public Object getSpecificValue(String key) {
        return this.addData.get(key);
    }

    public void loadNBTData(NBTTagCompound compound) {
        if (!compound.func_74764_b("MiniMapData")) {
            return;
        }
        NBTTagCompound nbt = compound.func_74775_l("MiniMapData");
        this.modName = nbt.func_74779_i("ModName");
        this.points.clear();
        NBTTagList list = nbt.func_150295_c("Data", 10);
        if (list.func_74745_c() != 0) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbtList = list.func_150305_b(i);
                if (nbtList.func_150297_b("Points", 9) || nbtList.func_150297_b("DimensionID", 3)) {
                    for (int j = 0; j < nbtList.func_150295_c("Points", 10).func_74745_c(); ++j) {
                        MiniMapData mmd = new MiniMapData();
                        mmd.load(nbtList.func_150295_c("Points", 10).func_150305_b(j));
                        this.points.add(mmd);
                    }
                    continue;
                }
                MiniMapData mmd = new MiniMapData();
                mmd.load(nbtList);
                this.points.add(mmd);
            }
        }
    }

    public void removeQuestPoints(int questId) {
        boolean remove = false;
        ArrayList<MiniMapData> tempList = new ArrayList<MiniMapData>(this.points);
        for (MiniMapData mmd : tempList) {
            if (!mmd.isQuestTask(questId, -1)) continue;
            this.points.remove(mmd);
            remove = true;
        }
        if (remove) {
            this.update = true;
        }
    }

    @Override
    public boolean removePoint(int id) {
        if (id < 0 || id >= this.points.size()) {
            return false;
        }
        MiniMapData mmd = this.points.get(id);
        boolean remove = false;
        if (mmd != null && mmd.id == id) {
            remove = this.points.remove(mmd);
        }
        if (!remove) {
            for (MiniMapData mmds : this.points) {
                if (mmds.id == id) {
                    remove = this.points.remove(mmds);
                }
                if (!remove) continue;
                break;
            }
        }
        if (remove) {
            this.update = true;
        }
        return true;
    }

    @Override
    public boolean removePoint(String name) {
        name = Util.instance.deleteColor(name);
        for (MiniMapData mmd : this.points) {
            if (!mmd.name.equals(name) || !this.points.remove(mmd)) continue;
            this.update = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean removePoints(int dimensionId) {
        boolean remove = false;
        ArrayList<MiniMapData> tempList = new ArrayList<MiniMapData>(this.points);
        block0: for (MiniMapData mmd : tempList) {
            for (int id : mmd.dimIDs) {
                if (id != dimensionId || !this.points.remove(mmd)) continue;
                remove = true;
                continue block0;
            }
        }
        if (remove) {
            this.update = true;
        }
        return remove;
    }

    public NBTTagCompound saveNBTData(NBTTagCompound compound) {
        compound.func_74782_a("MiniMapData", (NBTBase)this.getNBT());
        return compound;
    }

    public void update(EntityPlayerMP player) {
        boolean needSend = this.update;
        if (!needSend) {
            for (MiniMapData mmd : this.points) {
                if (!mmd.isUpdate()) continue;
                needSend = true;
                break;
            }
        }
        if (needSend) {
            this.update = false;
            Server.sendData(player, EnumPacketClient.MINIMAP_DATA, this.saveNBTData(new NBTTagCompound()));
        }
    }

    public MiniMapData get(MiniMapData mmd) {
        for (MiniMapData mmp : this.points) {
            boolean equalDimIDs;
            boolean bl = equalDimIDs = mmp.dimIDs.length == mmd.dimIDs.length;
            if (equalDimIDs) {
                int eq = 0;
                block1: for (int idp : mmp.dimIDs) {
                    for (int idd : mmd.dimIDs) {
                        if (idp != idd) continue;
                        ++eq;
                        continue block1;
                    }
                }
                boolean bl2 = equalDimIDs = mmp.dimIDs.length == eq;
            }
            if (!equalDimIDs || !mmp.name.equals(mmd.name) || !mmp.type.equals(mmd.type) || !mmp.pos.getMCBlockPos().equals((Object)mmd.pos.getMCBlockPos())) continue;
            return mmp;
        }
        return null;
    }
}

